package com.vf106.tools.activity.base;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;

import com.vf106.tools.R;

/**
 * Created by maorui on 2018/3/6.
 */
public abstract class BaseActivity extends AppCompatActivity {
    protected RelativeLayout aviLoadView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView();
        ViewGroup rootView = (ViewGroup) findViewById(android.R.id.content);
        addLoadView(rootView);
        initViews();
        setTitle();
        setListener();
        initViewData();
    }

    protected abstract void setContentView();

    protected abstract void initViews();

    protected abstract void setTitle();

    protected abstract void setListener();

    protected abstract void initViewData();

    private void addLoadView(ViewGroup root) {
        View.inflate(this, R.layout.view_load, root);
        aviLoadView = root.findViewById(R.id.avi_load);
    }

    public void showLoadView() {
        aviLoadView.setVisibility(View.VISIBLE);
    }

    public void hideLoadView() {
        aviLoadView.setVisibility(View.GONE);
    }

    public void toast(String msg) {
        Toast.makeText(this.getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
    }

    /**
     * Network Status Determination
     * @param context
     * @return
     */
    public boolean isNetworkConnected(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    public void setActionBarTitle(String title) {
        /*ActionBar actionBar = getSupportActionBar();
        assert actionBar != null;
        actionBar.setTitle(title);
        actionBar.setDisplayHomeAsUpEnabled(true);*/
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                this.finish();
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        setContentView(R.layout.view_null);
    }
}
